#pragma	once

#include "FTNStruc.hpp"
#include "Flag.h"
#include "CfgParse.hpp"
#include "Common.hpp"


// TODO: allow autocreation of passthrough areas


const		PASSWORD_SIZE     = 16;
const int	MAIN_ADDRESS      = -1;
const int	UNDEFINED_ADDRESS = -2;


class CLink {
public:
	CLink();
	virtual ~CLink() {}

	const tstring& getName() const                  { return name; }
	void           setName(const tstring& newName ) { name = newName; }

	int  getSendPriority() const          { return sendPriority; }
	void setSendPriority(int newPriority) { sendPriority = newPriority; }

	int  getReceivePriority() const          { return receivePriority; }
	void setReceivePriority(int newPriority) { receivePriority = newPriority; }

	int  getActivity() const          { return activity; }
	void setActivity(int newActivity) { activity = newActivity; }

	bool canAccessGroup(const tstring& groupName) const;
	void addGroup(const tstring& groupName)        { groups.push_back( groupName ); }
	bool removeGroup(const tstring& groupName);

	int getGroupsCount() const { return groups.size(); }
	const tstring& getGroup(int index) const { return groups[index]; }

	const SFTNAddress& getAddress() const        { return address; }
	void  setAddress(const SFTNAddress& newAddr) { address = newAddr; }

	const tstring& getPassword() const { return password; }
	void setPassword(const tstring& newPwd) { password = newPwd; }

	// TODO: where these methods should be?

	OutboundType	getOutboundType() const					{ return outboundType;    }
	void			setOutboundType(OutboundType newType)	{ outboundType = newType; }

	FlavourType	getFlavourType() const				{ return flavourType;    }
	void		setFlavourType(FlavourType newType)	{ flavourType = newType; }

	tstring getFileBoxPath() const;

	void           setAvailAreasFileName(const tstring& newName) { availAreasFileName = newName; }
	const tstring& getAvailAreasFileName() const                 { return availAreasFileName; }

	void           setRobotName(const tstring& newName) { robotName = newName; }
	const tstring& getRobotName() const { return robotName; }

	void  setAutoCreatedPathName(const tstring& newName) { autoCreatedPathName = newName; }
	const tstring& getAutoCreatedPathName() const        { return autoCreatedPathName; }

	void setAllowAreaCreation(bool newFlag) { allowAreaCreationFlag = newFlag; }

	bool canCreateAreas() const { return allowAreaCreationFlag; }

	void  setDefaultGroup(const tstring& groupName) { defaultGroup = groupName; }
	const tstring& getDefaultGroup() const          { return defaultGroup; }

	void setAutocreatedSendPriority(int priority) { autocreatedSendPriority = priority; }
	int  getAutocreatedSendPriority() const       { return autocreatedSendPriority; }

	void setAutocreatedReceivePriority(int priority) { autocreatedReceivePriority = priority; }
	int  getAutocreatedReceivePriority() const       { return autocreatedReceivePriority; }

	const SFTNAddress& getOurAddress() const						{ return ourAddress; }
	void			   setOurAddress(const SFTNAddress& newAddress) { ourAddress = newAddress; }

	void setAKASpecified(bool newFlag) { akaSpecified = newFlag; }
	bool isAKASpecified() const        { return akaSpecified;    }
protected:
	tstring		name;
	SFTNAddress	address;
	tstring		password;
	int			activity;

	OutboundType	outboundType;
	FlavourType		flavourType;

	int			sendPriority;
	int			receivePriority;

	VTString	groups;

	CFlag		allowAreaCreationFlag;
	tstring		autoCreatedPathName;
	tstring		defaultGroup;
	int			autocreatedSendPriority;
	int			autocreatedReceivePriority;

	tstring		availAreasFileName;
	tstring		robotName;

	SFTNAddress	ourAddress;
	/**
	 * We need flag to know whether AKA was specified in config or not
	 * (we use this flag when saving config)
	 */
	bool		akaSpecified;
};
typedef CLink*			PLink;
typedef CLink*			LinkPtr;
typedef const CLink*	ConstLinkPtr;
